### Cobalt API Tag


Cobalt/POSIX 库中的所有服务，或属于基于 Copperplate 库的 API 的服务，可能会限制在特定的调用上下文中，或带有特定的副作用。

在双内核模式下，Cobalt API 支持所有其他面向应用的 API，通过 Cobalt 实时核心提供 POSIX 实时服务。因此，以下信息适用于所有 xkernel 提供的面向应用的 API，例如 Cobalt/POSIX 库、Alchemy API，以及所有 RTOS 模拟器。为了描述这些信息，本节记录的每个服务在适用时都带有一组标签。

#### 注意

xkernel 线程是指由 xkernel API 服务创建的任何线程，包括双内核模式下的实时 Cobalt/POSIX 线程。常规/普通 POSIX 线程是指直接通过 Mercury 或 Cobalt 上的标准基于 glibc 的 POSIX 服务创建的任何线程（即 NPTL/linuxthreads __STD(pthread_create())），不包括那些之后被提升到实时域的线程（即在 Cobalt 上"影子化"）。

---
### 上下文标签

| 标签                | 进入时的上下文说明                                                        |
| ------------------- | ------------------------------------------------------------------------- |
| xthread-only        | 必须从 xkernel 线程调用                                                   |
| xhandler-only       | 必须从 xkernel 处理程序调用。参见注释。                                   |
| xcontext            | 可以从任何 xkernel 上下文（线程或处理程序）调用                           |
| pthread-only        | 必须从常规 POSIX 线程调用                                                 |
| thread-unrestricted | 可以从 xkernel 或常规 POSIX 线程调用                                      |
| xthread-nowait      | 可以从 xkernel 线程无限制调用，或从常规线程作为非阻塞服务调用。参见注释。 |
| unrestricted        | 可以从上述任何上下文调用                                                  |

#### 注释

xkernel 处理程序用于基于 Copperplate API 的回调通知，例如超时。此上下文不会映射到常规的 Linux 信号处理程序，它实际上是由一个特殊的线程上下文支持的，因此在代表此类处理程序运行时，API 实现可以在内部调用异步不安全的 POSIX 服务。因此，从异步常规信号处理程序调用 xkernel API 服务是根本不安全的。
在 Cobalt 上，主线程是一个特殊情况，它开始时是一个常规的 POSIX 线程，然后在初始化过程中自动切换到 Cobalt 线程，在调用 main() 例程之前，除非禁用了自动引导（参见 [构建实时程序(手动启动)](../buildrt/compile-code-manual) ）。
在 Cobalt 核心上运行应用程序时可能的副作用（即双内核配置）

| 标签             | 描述                   |
| ---------------- | ---------------------- |
| switch-primary   | 调用者可能切换到主模式 |
| switch-secondary | 调用者可能切换到次模式 |

### 注释

作为经验法则，任何可能阻塞调用者的服务，如果从次模式调用，会导致切换到主模式。如果服务可以完全在用户空间完成而不需要任何系统调用，则此规则可能不适用，这归因于特定的优化（例如在无争用情况下直接从用户空间快速获取信号量资源）。因此，switch-{primary, secondary} 标签表示服务将始终切换调用者到所述模式，或可能需要这样做，具体取决于上下文。没有此类标签表示此类服务可以在任意模式下完成，因此不会导致切换。